/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : lcd.h
* Author             : MCD Application Team
* Date First Issued  : 18/07/2003
* Description        : STR71x Demo Board LCD screen driver for for the STR71x Real Time 
*                      Clock Application Example application note (AN 1780).
********************************************************************************
* History:
*  04/10/2003 : V1.0
*  30/11/2004 : V2.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#ifndef __LCD_H
#define __LCD_H

#include "71x_type.h"

void LCD_Delay(u16 time);
void LCD_Init(void);
void LCD_AutoScrollOn(void);
void LCD_AutoScrollOff(void);
void LCD_SetCursorPosition(u8 col, u8 row);
void LCD_SetCursorHome(void);
void LCD_UnderlineCursorOn(void);
void LCD_UnderlineCursorOff(void);
void LCD_BlockCursorOn(void);
void LCD_BlockCursorOff(void);
void LCD_CursorLeft(void);
void LCD_CursorRight(void);

void LCD_DisplayCharacter (u8 c, u8 col, u8 row);
void LCD_CreateCharacter(u8 c, u8 *pattern);

void LCD_String(char *String, u8 col, u8 row);
void LCD_ClearLine (u8 line);

#define gotoxy(X,Y)  LCD_SetCursorPosition(X,Y)

void LCD_sendchar(char tempch);
void LCDInit(void);

#endif // __LCD_H

/*******************************************************************************/
